﻿using Harmony;
using RimWorld;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Verse;
using Verse.AI;
using System.Reflection;
using UnityEngine;

namespace JecrellsEverlastingApparel
{
    /*
     * 
     *  Harmony Classes
     *  ===============
     *  Harmony is a system developed by pardeike (aka Brrainz).
     *  It allows us to use pre/post method patches instead of using detours.
     * 
     */
    [StaticConstructorOnStartup]
    static class HarmonyEverlastingApparel
    {
        //Static Constructor
        /*
         * Contains 1 Harmony patch.
         * ===================
         * 
         * [PREFIX] MentalBreaker -> TryDoRandomMoodCausedMentalBreak
         * 
         */
        static HarmonyEverlastingApparel()
        {
            HarmonyInstance harmony = HarmonyInstance.Create("rimworld.jecrell.everlastingapparel");
            harmony.Patch(AccessTools.Method(typeof(Pawn_ApparelTracker), "TakeWearoutDamageForDay"), new HarmonyMethod(typeof(HarmonyEverlastingApparel).GetMethod("TakeWearoutDamageForDay_PreFix")), null);
        }

        /// <summary>
        /// Disable the entire process from running.
        /// </summary>
        /// <param name="__instance"></param>
        /// <param name="ap"></param>
        public static bool TakeWearoutDamageForDay_PreFix(Pawn_ApparelTracker __instance, Thing ap)
        {
            return false;
        }
    }
}
